/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.watch.ackandget;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class AckAndGetWatchRequest
extends BaseNodesRequest<AckAndGetWatchRequest> {
    private String watchId;
    private String actionId;
    private boolean ack;

    public AckAndGetWatchRequest(String watchId, String actionId, boolean ack) {
        super((String[])null);
        this.watchId = watchId;
        this.actionId = actionId;
        this.ack = ack;
    }

    public AckAndGetWatchRequest(StreamInput in) throws IOException {
        super(in);
        this.watchId = in.readString();
        this.ack = in.readBoolean();
        this.actionId = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.watchId);
        out.writeBoolean(this.ack);
        out.writeOptionalString(this.actionId);
    }

    public ActionRequestValidationException validate() {
        if (this.watchId == null || this.watchId.length() == 0) {
            return new ActionRequestValidationException();
        }
        return null;
    }

    public String getWatchId() {
        return this.watchId;
    }

    public void setWatchId(String watchId) {
        this.watchId = watchId;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public boolean isAck() {
        return this.ack;
    }

    public void setAck(boolean ack) {
        this.ack = ack;
    }
}

